﻿/*
  KeeUIExt
  Copyright (C) 2014-2025 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Reflection;
using System.Text;
using System.Windows.Forms;

namespace KeeUIExt
{
	internal sealed class KueMessageFilter : IMessageFilter
	{
		private readonly KueOptions m_opt;

		public KueMessageFilter(KueOptions opt)
		{
			if(opt == null) throw new ArgumentNullException("opt");

			m_opt = opt;
		}

		public bool PreFilterMessage(ref Message m)
		{
			try
			{
				if(m.Msg == NativeMethods.WM_MOUSEWHEEL)
					OnMouseWheel(ref m);
			}
			catch(Exception) { Debug.Assert(false); }

			return false;
		}

		private void OnMouseWheel(ref Message m)
		{
			IntPtr hWnd = m.HWnd;
			if(hWnd == IntPtr.Zero) { Debug.Assert(false); return; }

			bool bUp;
			short shDelta = (short)(m.WParam.ToInt64() >> 16);
			if(shDelta > 0) bUp = true;
			else if(shDelta < 0) bUp = false;
			else return;

			if(m_opt.ScrollMenusWithMouseWheel)
			{
				ToolStripDropDownMenu tsddm = (Control.FromHandle(hWnd) as
					ToolStripDropDownMenu);
				if(tsddm != null)
				{
					PropertyInfo pi = typeof(ToolStripDropDownMenu).GetProperty(
						"RequiresScrollButtons", BindingFlags.NonPublic |
						BindingFlags.Instance);
					if((pi != null) && (bool)pi.GetValue(tsddm, null))
					{
						pi = typeof(ToolStripDropDownMenu).GetProperty(
							(bUp ? "UpScrollButton" : "DownScrollButton"),
							BindingFlags.NonPublic | BindingFlags.Instance);
						object o = ((pi != null) ? pi.GetValue(tsddm, null) : null);
						if(o != null)
						{
							MethodInfo mi = o.GetType().GetMethod("Scroll",
								BindingFlags.NonPublic | BindingFlags.Instance,
								null, Type.EmptyTypes, null);
							if(mi != null) mi.Invoke(o, null);
							else { Debug.Assert(false); }
						}
						else { Debug.Assert(false); }
					}
					else { Debug.Assert(pi != null); }
				}
			}
		}
	}
}
